
//=======================================================
//  This code is generated by Terasic System Builder
//=======================================================

module Laboratorio7(

	//////////// CLOCK //////////
	CLOCK_50,

	//////////// LED //////////
	LED,

	//////////// KEY //////////
	KEY,

	//////////// SW //////////
	SW,

	//////////// SDRAM //////////
	DRAM_ADDR,
	DRAM_BA,
	DRAM_CAS_N,
	DRAM_CKE,
	DRAM_CLK,
	DRAM_CS_N,
	DRAM_DQ,
	DRAM_DQM,
	DRAM_RAS_N,
	DRAM_WE_N,

	//////////// EPCS //////////
	EPCS_ASDO,
	EPCS_DATA0,
	EPCS_DCLK,
	EPCS_NCSO,

	//////////// Accelerometer and EEPROM //////////
	G_SENSOR_CS_N,
	G_SENSOR_INT,
	I2C_SCLK,
	I2C_SDAT,

	//////////// ADC //////////
	ADC_CS_N,
	ADC_SADDR,
	ADC_SCLK,
	ADC_SDAT,

	//////////// 2x13 GPIO Header //////////
	GPIO_2,
	GPIO_2_IN,

	//////////// GPIO_0, GPIO_0 connect to GPIO Default //////////
	GPIO,
	GPIO_IN,

	//////////// GPIO_1, GPIO_1 connect to GPIO Default //////////
	GPIO_B,
	GPIO_B_IN 
);

//=======================================================
//  PARAMETER declarations
//=======================================================


//=======================================================
//  PORT declarations
//=======================================================

//////////// CLOCK //////////
input 		          		CLOCK_50;

//////////// LED //////////
output		     [7:0]		LED;

//////////// KEY //////////
input 		     [1:0]		KEY;

//////////// SW //////////
input 		     [3:0]		SW;

//////////// SDRAM //////////
output		    [12:0]		DRAM_ADDR;
output		     [1:0]		DRAM_BA;
output		          		DRAM_CAS_N;
output		          		DRAM_CKE;
output		          		DRAM_CLK;
output		          		DRAM_CS_N;
inout 		    [15:0]		DRAM_DQ;
output		     [1:0]		DRAM_DQM;
output		          		DRAM_RAS_N;
output		          		DRAM_WE_N;

//////////// EPCS //////////
output		          		EPCS_ASDO;
input 		          		EPCS_DATA0;
output		          		EPCS_DCLK;
output		          		EPCS_NCSO;

//////////// Accelerometer and EEPROM //////////
output		          		G_SENSOR_CS_N;
input 		          		G_SENSOR_INT;
output		          		I2C_SCLK;
inout 		          		I2C_SDAT;

//////////// ADC //////////
output		          		ADC_CS_N;
output		          		ADC_SADDR;
output		          		ADC_SCLK;
input 		          		ADC_SDAT;

//////////// 2x13 GPIO Header //////////
inout 		    [12:0]		GPIO_2;
input 		     [2:0]		GPIO_2_IN;

//////////// GPIO_0, GPIO_0 connect to GPIO Default //////////
inout 		    [33:0]		GPIO;
input 		     [1:0]		GPIO_IN;

//////////// GPIO_1, GPIO_1 connect to GPIO Default //////////
inout 		    [33:0]		GPIO_B;
input 		     [1:0]		GPIO_B_IN;


//=======================================================
//  REG/WIRE declarations
//=======================================================




//=======================================================
//  Structural coding
//=======================================================
wire [10:0]CounterX;
wire [10:0]CounterY;


reg[3:0] lcd_r_out;
reg[3:0] lcd_g_out;
reg[3:0] lcd_b_out;

wire V_SYNC;
wire H_SYNC;
wire video_on;

assign GPIO[0]=lcd_r_out[3];
assign GPIO[1]=lcd_r_out[2];
assign GPIO[3]=lcd_r_out[1];
assign GPIO[5]=lcd_r_out[0];
assign GPIO[7]=lcd_g_out[3];
assign GPIO[9]=lcd_g_out[2];
assign GPIO[11]=lcd_g_out[1];
assign GPIO[13]=lcd_g_out[0];
assign GPIO[15]=lcd_b_out[3];
assign GPIO[17]=lcd_b_out[2];
assign GPIO[19]=lcd_b_out[1];
assign GPIO[21]=lcd_b_out[0];
assign GPIO[23]=~V_SYNC;
assign GPIO[25]=~H_SYNC;


reg [10:0]pos_x;
reg pos_x_flag =1'b0;
reg [10:0]pos_y;
reg pos_y_flag =1'b0;
wire frame =(CounterX==11'd639)&&(CounterY==11'd479);

wire clk_25mhz;
pll_25mhz pll_25mhz_inst
(
	.inclk0(CLOCK_50) ,	// input  inclk0_sig
	.c0(clk_25mhz) ,	// output  c0_sig
);

mi_vga mi_vga_inst
(
	.clk(clk_25mhz) ,	// input  clk_sig
	.h_sync(H_SYNC) ,	// output  h_sync_sig
	.v_sync(V_SYNC) ,	// output  v_sync_sig
	.video_on(video_on) ,	// output  video_on_sig
	.pixel_x(CounterX) ,	// output [N-1:0] pixel_x_sig
	.pixel_y(CounterY) 	// output [N-1:0] pixel_y_sig
);


//Controles de SNES
wire [11:0]SNES_control1;
wire [11:0]SNES_control2;
FSM_SNES_Decoder Control1
(
	.clock_50(CLOCK_50) ,	// input  clock_50_sig
	.Data(GPIO_B[0]) ,	// input  Data_sig
	.latch(GPIO_B[1]) ,	// output  latch_sig
	.clock(GPIO_B[2]), 	// output  clock_sig
	.start(1'b1) ,	// input  start_sig
	.state_Buttins(SNES_control1[11:0]) ,	// output [11:0] state_Buttins_sig
	.finish()	// output  finish_sig
);

FSM_SNES_Decoder Control2
(
	.clock_50(CLOCK_50) ,	// input  clock_50_sig
	.Data(GPIO_B[3]) ,	// input  Data_sig
	.latch(GPIO_B[4]) ,	// output  latch_sig
	.clock(GPIO_B[5]), 	// output  clock_sig
	.start(1'b1) ,	// input  start_sig
	.state_Buttins(SNES_control2[11:0]) ,	// output [11:0] state_Buttins_sig
	.finish()	// output  finish_sig
);

assign LED[7:0]= KEY[0]? SNES_control1[7:0]:SNES_control2[7:0];

wire [10:0]goku_x1,goku_x2,goku_x3,goku_x4,goku_y1,goku_y2,goku_y3,goku_y4;
wire goku_on_off1,goku_on_off2,goku_on_off3,goku_on_off4;
wire [3:0]goku_scale1,goku_scale2,goku_scale3,goku_scale4;
wire [31:0]nota,nota2,nota3,nota4;
    mi_nios u0 (
        .clk_clk            (CLOCK_50),            //         clk.clk
        .reset_reset_n (1'b1), //   reset.reset_n
		  .ram_clk_clk   (DRAM_CLK),    // ram_clk.clk
		  //SDRAM
        .sdram_dq      (DRAM_DQ),      //   sdram.dq
        .sdram_cas_n   (DRAM_CAS_N),   //        .cas_n
        .sdram_ba      (DRAM_BA),      //        .ba
        .sdram_dqm     (DRAM_DQM),     //        .dqm
        .sdram_cs_n    (DRAM_CS_N),    //        .cs_n
        .sdram_cke     (DRAM_CKE),     //        .cke
        .sdram_addr    (DRAM_ADDR),    //        .addr
        .sdram_we_n    (DRAM_WE_N),    //        .we_n
        .sdram_ras_n   (DRAM_RAS_N),   //        .ras_n
		  //EPCS
        .epcs_sce      (EPCS_NCSO),      //    epcs.sce
        .epcs_data0    (EPCS_DATA0),    //        .data0
        .epcs_dclk     (EPCS_DCLK),     //        .dclk
        .epcs_sdo      (EPCS_ASDO),      //        .sdo

		  //SW
        .sw_export     (SW[3:0]),   //      sw.export
		  
		  //simple game
		  .goku_x1_export       (goku_x1[10:0]),       //       goku_x1.export
        .goku_x2_export       (goku_x2[10:0]),       //       goku_x2.export
        .goku_x3_export       (goku_x3[10:0]),       //       goku_x3.export
        .goku_x4_export       (goku_x4[10:0]),       //       goku_x4.export
        .goku_y1_export       (goku_y1[10:0]),       //       goku_y1.export
        .goku_y2_export       (goku_y2[10:0]),       //       goku_y2.export
        .goku_y3_export       (goku_y3[10:0]),       //       goku_y3.export
        .goku_y4_export       (goku_y4[10:0]),       //       goku_y4.export
		  .on_off1_export       (goku_on_off1),       //       on_off1.export
        .on_off2_export       (goku_on_off2),       //       on_off2.export
        .on_off3_export       (goku_on_off3),       //       on_off3.export
        .on_off4_export       (goku_on_off4),   
		  .scale1_export        (goku_scale1[3:0]),        //        scale1.export
        .scale2_export        (goku_scale2[3:0]),        //        scale2.export
        .scale3_export        (goku_scale3[3:0]),        //        scale3.export
        .scale4_export        (goku_scale4[3:0]),      
		  .snes_control1_export (SNES_control1[11:0]), // snes_control1.export
        .snes_control2_export (SNES_control2[11:0]),
		  .nota_export(nota[31:0]),
		  .nota2_export(nota2[31:0]),
		  .nota3_export(nota3[31:0]),
		  .nota4_export(nota4[31:0])
    );
	 


 
wire render1_on,render2_on,render3_on,render4_on;
wire [11:0]render1_color,render2_color,render3_color,render4_color;
render_g1 goku1
(
	.clk(clk_25mhz) ,	// input  clk_sig
	.scale(goku_scale1[3:0]) ,	// input [3:0] scale_sig
	.on_off(goku_on_off1) ,	// input  on_off_sig
	.x_video(CounterX[10:0]) ,	// input [10:0] x_video_sig
	.y_video(CounterY[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(goku_x1[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(goku_y1[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render1_on) ,	// output  image_on_sig
	.color(render1_color[11:0]) 	// output [11:0] color_sig
);
render_g2 goku2
(
	.clk(clk_25mhz) ,	// input  clk_sig
	.scale(goku_scale2[3:0]) ,	// input [3:0] scale_sig
	.on_off(goku_on_off2) ,	// input  on_off_sig
	.x_video(CounterX[10:0]) ,	// input [10:0] x_video_sig
	.y_video(CounterY[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(goku_x2[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(goku_y2[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render2_on) ,	// output  image_on_sig
	.color(render2_color[11:0]) 	// output [11:0] color_sig
);
render_g3 goku3
(
	.clk(clk_25mhz) ,	// input  clk_sig
	.scale(goku_scale3[3:0]) ,	// input [3:0] scale_sig
	.on_off(goku_on_off3) ,	// input  on_off_sig
	.x_video(CounterX[10:0]) ,	// input [10:0] x_video_sig
	.y_video(CounterY[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(goku_x3[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(goku_y3[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render3_on) ,	// output  image_on_sig
	.color(render3_color[11:0]) 	// output [11:0] color_sig
);
render_g4 goku4
(
	.clk(clk_25mhz) ,	// input  clk_sig
	.scale(goku_scale4[3:0]) ,	// input [3:0] scale_sig
	.on_off(goku_on_off4) ,	// input  on_off_sig
	.x_video(CounterX[10:0]) ,	// input [10:0] x_video_sig
	.y_video(CounterY[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(goku_x4[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(goku_y4[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render4_on) ,	// output  image_on_sig
	.color(render4_color[11:0]) 	// output [11:0] color_sig
);

wire [11:0]color_goku=render1_on? render1_color[11:0]:
							 render2_on? render2_color[11:0]:
							 render3_on? render3_color[11:0]:
							 render4_color[11:0];

wire audio1,audio2;
assign GPIO_B[33]=(CLOCK_50)? audio1:audio2;
Div_freq Div_freq_inst
(
	.reset(1'b0) ,	// input  reset_sig
	.clock(CLOCK_50) ,	// input  clock_sig
	.IN(nota[31:0]) ,	// input [31:0] IN_sig
	.OUT(audio1) 	// output  OUT_sig
);

Div_freq Div_freq_inst2
(
	.reset(1'b0) ,	// input  reset_sig
	.clock(CLOCK_50) ,	// input  clock_sig
	.IN(nota2[31:0]) ,	// input [31:0] IN_sig
	.OUT(audio2) 	// output  OUT_sig
);

wire audio3,audio4;
assign GPIO_B[32]=(CLOCK_50)? audio3:audio4;
Div_freq Div_freq_ins3
(
	.reset(1'b0) ,	// input  reset_sig
	.clock(CLOCK_50) ,	// input  clock_sig
	.IN(nota3[31:0]) ,	// input [31:0] IN_sig
	.OUT(audio3) 	// output  OUT_sig
);

Div_freq Div_freq_inst4
(
	.reset(1'b0) ,	// input  reset_sig
	.clock(CLOCK_50) ,	// input  clock_sig
	.IN(nota4[31:0]) ,	// input [31:0] IN_sig
	.OUT(audio4) 	// output  OUT_sig
);
							 

/*MUX DE VIDEO*/
always@(negedge clk_25mhz)
begin
	if(!video_on)
	begin
		lcd_r_out<=4'd0;
		lcd_g_out<=4'd0;
		lcd_b_out<=4'd0;
	end
	else
	begin
		lcd_r_out<=4'd0;
		lcd_g_out<=4'h9;
		lcd_b_out<=4'hF;
		if(render1_on || render2_on || render3_on || render4_on)
		begin
			lcd_r_out<=color_goku[11:8];
			lcd_g_out<=color_goku[7:4];
			lcd_b_out<=color_goku[3:0];
		end
	end
end



endmodule
