module FSM_SNES_Decoder(clock_50, Data, start, state_Buttins, finish, latch, clock);

input clock_50;
input Data;
input start;
output [11:0] state_Buttins;
output latch;
output clock;
output finish;


localparam IDLE   = 3'b000;
localparam SECOND = 3'b001;
localparam THIRD  = 3'b010;
localparam FOURTH = 3'b011;
localparam FIFTH  = 3'b100;
localparam FINISH = 3'b101;

reg [2:0] state = IDLE;
reg [9:0] delay=10'd0;
reg latch_temp=1'b0; 
reg clock_temp=1'b0;
reg finish_temp=1'b0;
reg [3:0] numero=4'd0;
reg [14:0] botones_reales=15'd0;
reg [14:0] botones=15'd0;
assign latch = latch_temp; 
assign clock = clock_temp;
assign finish = finish_temp;
assign state_Buttins[11:0]=botones_reales[11:0];

always@(posedge clock_50)
begin
     case (state [2:0])
	      IDLE : begin
			      latch_temp  <= 1'b0;
					clock_temp  <= 1'b1;
					state [2:0] <= IDLE;
					finish_temp <= 1'b1;
					numero [3:0]<= 4'b0000;
					delay [9:0] <= 10'd0;
					if(start)
					   begin 
						state [2:0] <= SECOND;
						end
					 end
					 
			SECOND : begin
			         clock_temp  <= 1'b1;
						latch_temp  <= 1'b1;
						state [2:0] <= SECOND;
						delay [9:0] <= delay [9:0]+ 1'b1;
						numero [3:0]<= 4'd1; 
						finish_temp <= 1'b0;
						if (delay >= 600)
						    begin
							 state [2:0] <= THIRD;
							 delay [9:0] <= 10'd0;
							 end
						end
						
			THIRD : begin
			        latch_temp <= 1'b0;
					  clock_temp <= 1'b1;
					  finish_temp <= 1'b0;
					  numero [3:0] <= numero [3:0];
					  state [2:0] <= THIRD;
					  delay [9:0] <= delay[9:0]+ 1'b1;
					  if(delay >= 300)
					     begin
						  state[2:0]<= FOURTH;
						  delay [9:0] <= 10'd0;
						  end				  
			        end
					  
			FOURTH : begin
			         latch_temp <= 1'b0;
						clock_temp <= 1'b0;
						finish_temp <= 1'b0;
						numero [3:0] <= numero [3:0];
						delay [9:0] <= delay [9:0]+ 1'b1;
						if(delay [9:0] >= 300)
						   begin
							delay [9:0] <= 0;
							state [2:0] <= THIRD;
							numero [3:0] <= numero [3:0] + 1'b1;
							if(numero [3:0] >= 15)
							   begin
								state [2:0]<= FIFTH;
								end
							end
			         end
						
			FIFTH : begin
			        state [2:0] <= FIFTH;
					  latch_temp <= 1'b0;
					  clock_temp <= 1'b1;
					  finish_temp <= 1'b0;
					  numero [3:0] <= 4'd0;
					  delay [9:0] <= delay[9:0]+ 1'b1;
					  if(delay >= 600)
					     begin
						  state [2:0]<= finish;
						  end
					  end
					  
		  FINISH : begin
		           finish_temp <= 1'b1;
					  latch_temp <= 1'b0;
					  clock_temp <= 1'b1;
					  numero [3:0] <= 4'd0;
					  delay [9:0] <= delay [9:0];
					  state [2:0]<= IDLE;
		           end
	   endcase
end

		
		always @ ( negedge clock_temp , posedge finish)
	    begin
		   if(finish)
			begin
				botones_reales[14:0]<= botones[14:0];			
			end 
			else 
			begin
				botones[14:0]<= {Data , botones[14:1]};
			end
		end 
					  
endmodule 
	
						
			         
					
			