module ani_chan(input frame,input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);


wire render1_on;
wire [11:0]render1_color;
wire render2_on;
wire [11:0]render2_color;
wire render3_on;
wire [11:0]render3_color;
wire render4_on;
wire [11:0]render4_color;

reg [6:0]conteo=0;
always@(posedge frame)
begin
	conteo[6:0]<=conteo[6:0]+1'b1;
end

assign image_on=(conteo[5:4]==2'b00)?render1_on:
					 (conteo[5:4]==2'b01)?render2_on:
					 (conteo[5:4]==2'b10)?render3_on:
					 render4_on;
					 
assign color[11:0]=(conteo[5:4]==2'b00)?render1_color[11:0]:
					 (conteo[5:4]==2'b01)?render2_color[11:0]:
					 (conteo[5:4]==2'b10)?render3_color[11:0]:
					 render4_color[11:0];
					 

render1 render1_inst
(
	.clk(clk) ,	// input  clk_sig
	.scale(scale) ,	// input [3:0] scale_sig
	.on_off(on_off) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render1_on) ,	// output  image_on_sig
	.color(render1_color[11:0]) 	// output [11:0] color_sig
);
render2 render2_inst
(
	.clk(clk) ,	// input  clk_sig
	.scale(scale) ,	// input [3:0] scale_sig
	.on_off(on_off) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render2_on) ,	// output  image_on_sig
	.color(render2_color[11:0]) 	// output [11:0] color_sig
);
render3 render3_inst
(
	.clk(clk) ,	// input  clk_sig
	.scale(scale) ,	// input [3:0] scale_sig
	.on_off(on_off) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render3_on) ,	// output  image_on_sig
	.color(render3_color[11:0]) 	// output [11:0] color_sig
);
render4 render4_inst
(
	.clk(clk) ,	// input  clk_sig
	.scale(scale) ,	// input [3:0] scale_sig
	.on_off(on_off) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(render4_on) ,	// output  image_on_sig
	.color(render4_color[11:0]) 	// output [11:0] color_sig
);



endmodule
