module ani_nube(input frame,input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);

wire nube1_on;
wire [11:0]nube1_color;
wire nube2_on;
wire [11:0]nube2_color;
reg [6:0]conteo;
always@(posedge frame)
begin
	conteo[6:0]<=conteo[6:0]+1'b1;
end 

assign image_on=(conteo[6:0]>=7'd60)?nube2_on:nube1_on;
assign color[11:0]=(conteo[6:0]>=7'd60)?nube2_color[11:0]:nube1_color[11:0];

nube nube_inst
(
	.clk(clk) ,	// input  clk_sig
	.scale(4'd0) ,	// input [3:0] scale_sig
	.on_off(1'b1) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(nube1_on) ,	// output  image_on_sig
	.color(nube1_color[11:0]) 	// output [11:0] color_sig
);

sad_cloud nube_inst2
(
	.clk(clk) ,	// input  clk_sig
	.scale(4'd0) ,	// input [3:0] scale_sig
	.on_off(1'b1) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos[10:0]) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos[10:0]) ,	// input [10:0] y_pos_sig
	.image_on(nube2_on) ,	// output  image_on_sig
	.color(nube2_color[11:0]) 	// output [11:0] color_sig
);

endmodule
