module ani_pasto(input frame,input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);

wire pasto1_on;
wire [11:0]pasto1_color;

wire pasto2_on;
wire [11:0]pasto2_color;
reg [6:0]conteo;
always@(posedge frame)
begin
	conteo[6:0]<=conteo[6:0]+1'b1;
end 

assign image_on=conteo[6]?pasto2_on:pasto1_on;
assign color[11:0]=conteo[6]?pasto2_color[11:0]:pasto1_color[11:0];
 
pasto1 pasto1_inst
(
	.clk(clk) ,	// input  clk_sig
	.scale(scale) ,	// input [3:0] scale_sig
	.on_off(on_off) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig 
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos) ,	// input [10:0] y_pos_sig
	.image_on(pasto1_on) ,	// output  image_on_sig
	.color(pasto1_color[11:0]) 	// output [11:0] color_sig
);

pasto2 pastods_inst
(
	.clk(clk) ,	// input  clk_sig
	.scale(scale) ,	// input [3:0] scale_sig
	.on_off(on_off) ,	// input  on_off_sig
	.x_video(x_video[10:0]) ,	// input [10:0] x_video_sig
	.y_video(y_video[10:0]) ,	// input [10:0] y_video_sig
	.x_pos(x_pos) ,	// input [10:0] x_pos_sig
	.y_pos(y_pos) ,	// input [10:0] y_pos_sig
	.image_on(pasto2_on) ,	// output  image_on_sig
	.color(pasto2_color[11:0]) 	// output [11:0] color_sig
);
endmodule

