module corazon(input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);


wire [10:0]real_x=(x_video[10:0]>>scale[3:0])-(x_pos[10:0]>>scale[3:0]);
wire [10:0]real_y=(y_video[10:0]>>scale[3:0])-(y_pos[10:0]>>scale[3:0]);

wire [6:0]image_line;
wire [10:0]bit_posx=real_x[6:0]*7;
reg [0:244]datos;
assign image_line[0]=datos[bit_posx[10:0]+6];
assign image_line[1]=datos[bit_posx[10:0]+5];
assign image_line[2]=datos[bit_posx[10:0]+4];
assign image_line[3]=datos[bit_posx[10:0]+3];
assign image_line[4]=datos[bit_posx[10:0]+2];
assign image_line[5]=datos[bit_posx[10:0]+1];
assign image_line[6]=datos[bit_posx[10:0]+0];
assign image_on= (color[11:0]!=12'h000) & on_off & (real_x[10:0]<11'd35);

always@(posedge clk)
begin
  case(real_y[10:0])

     0:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000010000001100001000000011000001000000010000001000000100000010000001000000100000010000001000000100000010000001000001000000110000100000001100000100000001000000100000010000001000000100000010000001;
     1:datos[0:244]<=245'b00000010000001000000100000010000001000001000001010000110000011100010000000111000011000001010000010000000100000010000001000000100000010000001000000100000100000101000011000001110001000000011100010010000101000001000000010000001000000100000010000001;
     2:datos[0:244]<=245'b00000010000001000000100010100000101000101100011000001101000111000011010001101000111100011000001011000010100010100000001000000100000010001010000001100010110001100000110100011100001110000110100011110001100000101100001010001010000000100000010000001;
     3:datos[0:244]<=245'b00000010000001000101000001000010000000111100100010010010001001100100110010011001001100100100001100001010000001000001010000000100010100000101001010000011110010001001001000100110010011001001100100110010010000110000101000000100000101000000010000001;
     4:datos[0:244]<=245'b00000010000001000001100010110010010001010100101100010110000100000001110000111000100000010000010110001010100101110000011000000100000110011000001001000101010010110001011000010000000111000011100010000001000001011000101010010111000010100000010000001;
     5:datos[0:244]<=245'b00000010011001001101000101100001000001101100001100000100000010000001000000100000010000001100001001000011100001110011100001110100111000001000000100000001110000110001110000111000000100000010000111000000110000100100110110000111001101000000100000001;
     6:datos[0:244]<=245'b00000010000011001111000001110000110000010000001000000100000010000001000011100001110000111000011100000011000001100011100001110000001100000111000011000111000011100001110000111000011100001110000111000000100000010000001100000110001101000001010000001;
     7:datos[0:244]<=245'b00110010011100001110000001100011100001110000111000011100001110000111000011100001110000111000011100001110000111000011100001110000111110000110001110000111000011100001110000111000011100001110000111000011100001110000111000011100001110000111000000010;
     8:datos[0:244]<=245'b00000110011100001110000111000011100001110000111000011100001110000111000011100001110000111000011100001110000110100100000010000001000000100000001101000110100011010001110000111000011100001110000111000011100001110000111000011100001110000111000000101;
     9:datos[0:244]<=245'b00111000011100001110000111000011100001110000111000011100001110000111000011100001110000110100011010010000001000000100000010000001000000100000010000001000000011010001101000110100011100001110000111000011100001110000111000011100001110000110100011010;
     10:datos[0:244]<=245'b00110100011010001110000111000011100001110000111000011100001110000111000011100001101000110100100000010000101000010100010010001001000100100010010000101000010100001001101000110100011010001110000111000011100001110000111000011100001110000110100011010;
     11:datos[0:244]<=245'b00111000011010001110000111000011100001110000111000011100001110000111000011010001101001000010100001010000101000110100011010010001001000100011010001101000010100001010000100110100011010001101000111000011100001110000111000011100001110000110100011010;
     12:datos[0:244]<=245'b00111010011010001101000111000011100001110000111000011100001110000110100011010001101001000010100001010001101001000100100010010101001010100100010010001000110100110010000101001110011010001101000110100011100001110000111000011100001101000110100000101;
     13:datos[0:244]<=245'b01010000011100001101000110100011010001101000110100011010001101000110100011010010000101000010100011010010001010010101001010101001010100101001010101101000110100011010000101000010011010001101000110100011010001101000110100011010001101000110100011001;
     14:datos[0:244]<=245'b00000010000101010011100110100011010001101000110100011010001101000110100011010010000101001100100011010101101010010101010010101001010100101010010100101010110100011010011001000010011010001101000110100011010001101000110100011110010110000001000000001;
     15:datos[0:244]<=245'b00000010000010010110101001110011010001101000110100011010001101000110100100111010000101001100100011010101101010100101010010111001011100101010010100101010110100011010011001000010011010001101000110100011010001101000111100011000010111101100000000001;
     16:datos[0:244]<=245'b00000010000001001101001011010100111010011100110100011010001101000110100100111010000101001100100011010101101010100101010010111001011100101010010100101010110100011010011001000010011010001101000110100011110001111000010110110001001101000010100000001;
     17:datos[0:244]<=245'b00000010000001011000001011010101101010110101001110011010001101000110100011010010000101001100100011010101101010010101010010101001010100101010010100101010110100011010000101000010011010001101000111100010111000101101100100110011001110100000010000001;
     18:datos[0:244]<=245'b00000010000001000000100110100110100011010001011010100111001101000110100011010010000101001100100011010101101010010101001010101001010100101001010101101000110100011010000101000010011010001111000101110001011011001001101010011010000101000000010000001;
     19:datos[0:244]<=245'b00000010000001000000100000100101101011010001101000101101010011100110100011010010011101000010100110010001101010110101011010100101010010101011010101101000110100110010000101000010100000001111000010110010000011011001101110110000000000100000010000001;
     20:datos[0:244]<=245'b00000010000001000000100000010000101011010001101000101101010011100110100011010010011101000010100110010011001110000111000010101101010110111000010001101001100100001010000101000000011110001100000101000110110011100100001000000001000000100000010000001;
     21:datos[0:244]<=245'b00000010000001000000100000010001010001101001101000110100010110101001110011010001101001001110100001010011001001100111000011100001110000100011010011001001100100001010000101000000011000011101000011000111011010011101010000000001000000100000010000001;
     22:datos[0:244]<=245'b00000010000001000000100000010000001000001001011010110100011010001011010100111001101001001110100111010000101001100100110010011001001100100110010011001000010100111001101000111100001011011110001111010101111000001000000010000001000000100000010000001;
     23:datos[0:244]<=245'b00000010000001000000100000010000001000000100111010110100011010001011010100111001101000110100100111010011101001110100110010011001001100100001010011101001110100111001111000110000010000011110101111100000011000000100000010000001000000100000010000001;
     24:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000101011010001101000101101010011100110100011010010011101001110100111010011101001110100111010011100110100011010001111000010110001100011111100001000000001000000100000010000001000000100000010000001;
     25:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001001110001101000110100010011101001110011010001101001001110100111010011101001110100111001101000110100011110001100001100100111111001101000010100000001000000100000010000001000000100000010000001;
     26:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000101000110100110100010110101001110011010001101000110100011010001101000110100011010001101000110100101100100000001100010011010010100000000010000001000000100000010000001000000100000010000001;
     27:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000101010000011010010110101001110100111001101000110100011010001101000110100011010001101000111100010100011000101001110101000000000100000010000001000000100000010000001000000100000010000001;
     28:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000100000010101000001101001011010100111001101000110100011010001101000110100011010001101000110001000001010011101010000000001000000100000010000001000000100000010000001000000100000010000001;
     29:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000100000010000001010100000110100101101010011100110100011010001101000110100011010010110001101110100111010100000000010000001000000100000010000001000000100000010000001000000100000010000001;
     30:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000100000010000001000000101010000011010010110100110100011010001101000110100011010010111100110100101000000000100000010000001000000100000010000001000000100000010000001000000100000010000001;
     31:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010001010001110001011010011010001101000110100101101001101001010000000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001;
     32:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001000101000001000101101010011101011010011100000101000000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001;
     33:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000011010110100001010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001;
     34:datos[0:244]<=245'b00000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001000001100000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001000000100000010000001;
     default: datos[0:244]<=245'd0;

   endcase
end

//Map Color
assign color[11:0]=          (image_line[6:0]==1)?12'd0:
          (image_line[6:0]==2)?12'd1024:
          (image_line[6:0]==3)?12'd1792:
          (image_line[6:0]==4)?12'd2304:
          (image_line[6:0]==5)?12'd2048:
          (image_line[6:0]==6)?12'd2577:
          (image_line[6:0]==7)?12'd2867:
          (image_line[6:0]==8)?12'd2884:
          (image_line[6:0]==9)?12'd2594:
          (image_line[6:0]==10)?12'd256:
          (image_line[6:0]==11)?12'd3123:
          (image_line[6:0]==12)?12'd3464:
          (image_line[6:0]==13)?12'd3515:
          (image_line[6:0]==14)?12'd3771:
          (image_line[6:0]==15)?12'd3498:
          (image_line[6:0]==16)?12'd3157:
          (image_line[6:0]==17)?12'd3481:
          (image_line[6:0]==18)?12'd3208:
          (image_line[6:0]==19)?12'd3191:
          (image_line[6:0]==20)?12'd3140:
          (image_line[6:0]==21)?12'd3174:
          (image_line[6:0]==22)?12'd2901:
          (image_line[6:0]==23)?12'd2850:
          (image_line[6:0]==24)?12'd3106:
          (image_line[6:0]==25)?12'd768:
          (image_line[6:0]==26)?12'd2816:
          (image_line[6:0]==27)?12'd2611:
          (image_line[6:0]==28)?12'd2560:
          (image_line[6:0]==29)?12'd1536:
          (image_line[6:0]==30)?12'd2833:
          (image_line[6:0]==31)?12'd2576:
          (image_line[6:0]==32)?12'd2832:
          (image_line[6:0]==33)?12'd3088:
          (image_line[6:0]==34)?12'd3104:
          (image_line[6:0]==35)?12'd3360:
          (image_line[6:0]==36)?12'd3376:
          (image_line[6:0]==37)?12'd3392:
          (image_line[6:0]==38)?12'd3344:
          (image_line[6:0]==39)?12'd3072:
          (image_line[6:0]==40)?12'd512:
          (image_line[6:0]==41)?12'd3648:
          (image_line[6:0]==42)?12'd3664:
          (image_line[6:0]==43)?12'd3632:
          (image_line[6:0]==44)?12'd3089:
          (image_line[6:0]==45)?12'd3328:
          (image_line[6:0]==46)?12'd3680:
          (image_line[6:0]==47)?12'd3345:
          (image_line[6:0]==48)?12'd1280:
          (image_line[6:0]==49)?12'd3396:
          (image_line[6:0]==50)?12'd3447:
          (image_line[6:0]==51)?12'd3635:
          (image_line[6:0]==52)?12'd3584:
          (image_line[6:0]==53)?12'd3703:
          (image_line[6:0]==54)?12'd3754:
          (image_line[6:0]==55)?12'd3362:
          (image_line[6:0]==56)?12'd3616:
          (image_line[6:0]==57)?12'd3669:
          (image_line[6:0]==58)?12'd3139:
          (image_line[6:0]==59)?12'd3720:
          (image_line[6:0]==60)?12'd3430:
          (image_line[6:0]==61)?12'd3737:
          (image_line[6:0]==62)?12'd3618:
          (image_line[6:0]==63)?12'd3652:
          (image_line[6:0]==64)?12'd3413:
          (image_line[6:0]==65)?12'd3379:
             12'd0;


endmodule
