module google(input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);


wire [10:0]real_x=(x_video[10:0]>>scale[3:0])-(x_pos[10:0]>>scale[3:0]);
wire [10:0]real_y=(y_video[10:0]>>scale[3:0])-(y_pos[10:0]>>scale[3:0]);

wire [3:0]image_line;
wire [10:0]bit_posx=real_x[6:0]*4;
reg [0:199]datos;
assign image_line[0]=datos[bit_posx[10:0]+3];
assign image_line[1]=datos[bit_posx[10:0]+2];
assign image_line[2]=datos[bit_posx[10:0]+1];
assign image_line[3]=datos[bit_posx[10:0]+0];
assign image_on= (color[11:0]!=12'hfff) & on_off & (real_x[10:0]>=11'd0) & (real_x[10:0]<11'd50)& (real_y[10:0]>=11'd0) & (real_y[10:0]<11'd55);

always@(posedge clk)
begin
  case(real_y[10:0])

     0:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100100011001100110011001100110011001100110011001100110011001100110011001100110011010000010001;
     1:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100100011001100110011001100110011001100110011001100110011001100110011001100110011010000010001;
     2:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100010101010101100011001100110011001100110011001100110011001100110011001100110011001100110011011101010101;
     3:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     4:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011100001010101011000110011001100110011001100110011001100110011001100110011001100110011;
     5:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011100000010001011000110011001100110011001100110011001100110011001100110011001100110011;
     6:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011100000100010100100110011001100110011001100110011001100110011001100110011001100110011;
     7:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     8:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     9:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     10:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     11:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     12:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     13:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011;
     14:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100111010010001000100010001000100010001000100010001000100;
     15:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110100000100010001000100010001000100010001000100010001;
     16:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101010011001100110011001100110011001100110011001100110010011101110111011101110111010000010001000100010001;
     17:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000101011000001100110011001100110011001100110011001100110011001100110011001100110011100100010001000100010001;
     18:datos[0:199]<=200'b00010001000100010001000100010001000100010001000100010001000100010001000100010001000100010001000100011000001100110011001100110011001100110011001100110011001100110011001100110011101100010001000100010001;
     19:datos[0:199]<=200'b10011001011000010001000100010001000100010001000100010001000100010001000100010001000100011010100110010011001100110011001100110011001100111000010001000100010001000100010001000100010000010001000100010001;
     20:datos[0:199]<=200'b00110011100000010001000100010001000100010001000100010001000100010001000100010001000100010010001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     21:datos[0:199]<=200'b00110011100100010001000100010001000100010001000100010001000100010001000101010111011101110110001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     22:datos[0:199]<=200'b00110011100100010001000100010001000100010001000100010001000100010001000101110011001100110011001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     23:datos[0:199]<=200'b00110011100100010001000100010001000100010001000100010001000100010001000101110011001100110011001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     24:datos[0:199]<=200'b00110011001110111011010000010001000100010001000100010001000101101011101110010011001100110011001100110011001100110011001100110011001100110011101110111011101101100001000100010001000100010001000100010001;
     25:datos[0:199]<=200'b00110011001100110011011100010001000100010001000100010001000110000011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001110010001000100010001000100010001000100010001;
     26:datos[0:199]<=200'b00110011001100110011101001000100000100010001000101010100010010000011001100110011001100110011001100110011001100110011001100110011001100110011100110011000001110010001000100010001000100010001000100010001;
     27:datos[0:199]<=200'b00110011001100110011001100111001000100010001000101110011001100110011001100110011001100110011001100110011001100110011001100110011001100111001000100011011001110010001000100010001000100010001000100010001;
     28:datos[0:199]<=200'b00110011001100110011001100111011000100010001000101110011001100110011001100110011001100110011001100110011001100110011001100110011001100111001000100011011001110010001000100010001000100010001000100010001;
     29:datos[0:199]<=200'b00110011001100110011001100111000101110111011101110010011001100110011001100110011001100110011001100110011001100110011001100110011001100111001000100010100011101110001000100010001000100010001000100010001;
     30:datos[0:199]<=200'b00110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     31:datos[0:199]<=200'b00110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     32:datos[0:199]<=200'b00110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     33:datos[0:199]<=200'b00110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100111001000100010001000100010001000100010001000100010001000100010001;
     34:datos[0:199]<=200'b10101010001000110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100111000000100010001000100010001000100010001000100010001000100010001;
     35:datos[0:199]<=200'b00010001010100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011100010011011000100010001000100010001000100010001000100010001000100010001;
     36:datos[0:199]<=200'b00010001010010001000001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011101000010001000100010001000100010001000100010001000100010001000100010001;
     37:datos[0:199]<=200'b00010001000100010001101100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011101000010001000100010001000100010001000100010001000100010001000100010001;
     38:datos[0:199]<=200'b00010001000100010001100100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011001100110011101000010001000100010001000100010001000100010001000100010001000100010001;
     39:datos[0:199]<=200'b00010001000100010001011100100110001100110011001100110011001100110011001100110011001100110011001100110011001100110011100000100010010000010001000100010001000100010001000100010001000100010001000100010001;
     40:datos[0:199]<=200'b00010001000100010001000100010100001100110011001100110011001100110011001100110011001100110011001100110011001100110011100000010001000100010001000100010001000100010001000100010001000100010001000100010001;
     41:datos[0:199]<=200'b00010001000100010001000100010100100010000011001100110011001100110011001100110011001100110011001100110011001100111000100100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     42:datos[0:199]<=200'b00010001000100010001000100010001000100011001001100110011001100110011001100110011001100110011001100110011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     43:datos[0:199]<=200'b00010001000100010001000100010001000100011001001100110011001100110011001100110011001100110011001100110011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     44:datos[0:199]<=200'b00010001000100010001000100010001000100011010001010110011001100110011001100110011011000101011001100110011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     45:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001100110011001100110011000100011010001100110011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     46:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001100110011001100110011010100010010001100110011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     47:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001100110011101101010101000100010001010101010011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     48:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001100110011101100010001000100010001000100011000001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     49:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001110110110101000010001000100010001000101010011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     50:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001101010001000100010001000100010001000101010011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     51:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001101000001000100010001000100010001000101010011001100100001000100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     52:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001110001000001000010001000100010001000101010011001110001000100100010001000100010001000100010001000100010001000100010001000100010001000100010001;
     53:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001100110011011000010001000100010001000101010011001100110011100000010001000100010001000100010001000100010001000100010001000100010001000100010001;
     54:datos[0:199]<=200'b00010001000100010001000100010001000100010001000101110011001100110011011000010001000100010001000101010011001100110011100000010001000100010001000100010001000100010001000100010001000100010001000100010001;
     default: datos[0:199]<=200'd0;

   endcase
end

//Map Color
assign color[11:0]=          (image_line[3:0]==1)?12'd4095:
          (image_line[3:0]==2)?12'd2730:
          (image_line[3:0]==3)?12'd1365:
          (image_line[3:0]==4)?12'd3549:
          (image_line[3:0]==5)?12'd3822:
          (image_line[3:0]==6)?12'd2457:
          (image_line[3:0]==7)?12'd3276:
          (image_line[3:0]==8)?12'd1638:
          (image_line[3:0]==9)?12'd1911:
          (image_line[3:0]==10)?12'd3003:
          (image_line[3:0]==11)?12'd2184:
             12'd0;


endmodule
