module mi_vga(clk, h_sync, v_sync, video_on, pixel_x, pixel_y);
parameter N=11;
input clk;
output h_sync;
output v_sync;
output video_on;
output[N-1:0]pixel_x;
output [N-1:0]pixel_y;

reg[N-1:0]counter_x;
reg[N-1:0]counter_y;

reg h_sync_reg;
reg v_sync_reg;

localparam HD = 640; // horizontal display area
localparam HF = 48; // h front left border
localparam HB = 16;// h back right border
localparam HR = 96; // h retrace
localparam VD = 480;// vertical display area
localparam VF = 10;// v front top  border
localparam VB = 33;// v back bottom  border
localparam VR = 2;// v retrace


always@(posedge clk)
begin
	counter_y<=counter_y;
	if(counter_x>=(HD+HF+HB+HR-1)) 
	begin
		counter_x<=0;
		if(counter_y>=(VD+VF+VB+VR-1))
		begin
			counter_y<=0;
		end
		else
		begin
			counter_y<=counter_y+1'b1;
		end
	end
	else 
	begin
		counter_x<=counter_x+1'b1;
	end
end

always@(posedge clk)
begin
	h_sync_reg<= (counter_x>=(HD+HB)) && (counter_x<=(HD+HB+HR-1));
	v_sync_reg<= (counter_y>=(VD+VB)) && (counter_y<=(VD+VB+VR-1));
end
assign h_sync=h_sync_reg;
assign v_sync=v_sync_reg;
assign video_on=(counter_x<(HD)) &&	(counter_y<(VD));

assign pixel_x=counter_x;
assign pixel_y=counter_y;

endmodule