module nubecitita(input clk,
input on_off,
input [10:0]x_video,
input [10:0]y_video,
input [10:0]x_pos,
input [10:0]y_pos,
output nubecitita_on,
output [11:0]color);


wire [10:0]real_x=x_video[10:0]-x_pos[10:0];
wire [10:0]real_y=y_video[10:0]-y_pos[10:0];
reg [63:0]datos;
assign nubecitita_on=datos[~real_x[5:0]] & on_off & (real_x[10:0]<11'd64);
assign color[11:0]=nubecitita_on?12'hfff:12'd0;
//64*3
always@(posedge clk)
begin
	case(real_y[10:0])
	11'd0: datos[63:0]<=64'b0000000000000000000000000000000011111111110000000000000000000000;
	11'd1: datos[63:0]<=64'b0000000000000000000000000000011111111111111111000000000000000000;
	11'd2: datos[63:0]<=64'b0000000000000000000000000011111111111111111111111000000000000000;
	11'd3: datos[63:0]<=64'b0000000000000000000000011111111111111111111111111110000000000000;
	default: datos[63:0]<=64'd0;
endcase
end



endmodule
