module render_g1(input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);


wire [10:0]real_x=(x_video[10:0]>>scale[3:0])-(x_pos[10:0]>>scale[3:0]);
wire [10:0]real_y=(y_video[10:0]>>scale[3:0])-(y_pos[10:0]>>scale[3:0]);

wire [4:0]image_line;
wire [10:0]bit_posx=real_x[5:0]*5;
reg [0:144]datos;
assign image_line[0]=datos[bit_posx[10:0]+4];
assign image_line[1]=datos[bit_posx[10:0]+3];
assign image_line[2]=datos[bit_posx[10:0]+2];
assign image_line[3]=datos[bit_posx[10:0]+1];
assign image_line[4]=datos[bit_posx[10:0]+0];
assign image_on= (color[11:0]!=12'h0f0) & on_off & (real_x[10:0]>=11'd0) & (real_x[10:0]<11'd29)& (real_y[10:0]>=11'd0) & (real_y[10:0]<11'd39);

always@(posedge clk)
begin
  case(real_y[10:0])

     0:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100001000010000100001000010001000010000010000100001000100001000010000100001000010000010000100001;
     1:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100010000010000100001000100001000001000010001000010000100001000010000100001000010000100001000001;
     2:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100010000010000100010000110001000001000100001000010000110001100011000110001000010000010000100001;
     3:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100010000010001000010000110001000010000100001000011000110001100010000100000100001000010000100001;
     4:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100010000010001000010000100001000010000100001100011000110001000010000010000100001000010000100001;
     5:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100001000100001000010000100001000010000100001100011000100001000010000100001000001000010000100001;
     6:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100001000100001000010000100001100010000100001000010000100001100011000110001000010000010000100001;
     7:datos[0:144]<=145'b0000100001000010000100001000010000100001000010000100010000100001000010000110001100011000100001000010000110001100011000110001100010000100000100001;
     8:datos[0:144]<=145'b0000100001000010000100001000010000100001000010001000010000100001000010000110001100011000100001100010000100001100010000100001000010000100000100001;
     9:datos[0:144]<=145'b0000100001000010000100001000010000100001000010001000010000100001000010000100001100010001000001000100000100001000010000010000100001000100000100001;
     10:datos[0:144]<=145'b0000100001000010000100001000010000100010000100001000010000100001000010000100001000100000100001000010001000001000001000010000100001000010000100001;
     11:datos[0:144]<=145'b0000100001000010000100001000100001000010000100001000010000100001000101001010001000110001110100000010000100000100001000010000100001000010000100001;
     12:datos[0:144]<=145'b0000100001000010000100010000100001000010000100001000010000100010100100001110010000110010000100000010001100000100001000010000100001000010000100001;
     13:datos[0:144]<=145'b0000100001000010000100001000010000100010000100001000010000100010100100001010010000100001110011100111001110010000001000010000100100001000010000001;
     14:datos[0:144]<=145'b0000100001000010000100001000100001000010000100001000010000100001000101001110010100100001100011100110001100010100001000010010100110001110010000001;
     15:datos[0:144]<=145'b0000100001000010001000010000100001000010000100001000010000100001000010001010010100101001100011000110001010000100001000010010100100001000010100001;
     16:datos[0:144]<=145'b0000100001000010000100001000010000100001001010100101010010100101001001001000011000100001000010100101010010100100001001010011100110001000011100100;
     17:datos[0:144]<=145'b0000100001000010000100001000010010100101001100010001001010110101101010010010011000110001100100101010010110100100101001010011000100001100011000101;
     18:datos[0:144]<=145'b0000100001000010000100001001010010000111001100010001001001010010100101010010010100100001010100101011010010010000100011000010100110001010110000001;
     19:datos[0:144]<=145'b0000100001000010000100101001000011000110001100010000101001100011100101010100100100101010010101001001001000011100110011000110001100011000110000001;
     20:datos[0:144]<=145'b0000100001000010000100101001100011100110011000110000101001100010100101001010100101001010100100100101001010011000111001010011001100011000000100001;
     21:datos[0:144]<=145'b0000100001000010000100101001000011001100011000110000110001100011100100001010101001001010110100100001000010010100101001010010100101000010000100001;
     22:datos[0:144]<=145'b0000100001000010000100001001010010001100011000110000100001110010000101010110101101010010010000100001000010000100001000010000100001000010000100001;
     23:datos[0:144]<=145'b0000100001000010000100001000010010100101011000110000101001010010101101011100110101101011100100101001000010000100001000010000100001000010000100001;
     24:datos[0:144]<=145'b0000100001000010000100001000010000100001000010100101010011100111001110011100111001110010100100101001010010110001100000010000100001000010000100001;
     25:datos[0:144]<=145'b0000100001000010000100001000010000100001010010101001011010010101001001011100110101110010110101001001011111000001111011000000100001000010000100001;
     26:datos[0:144]<=145'b0000100001000010000100001000010000101001010010100101001010100101101010011100110101110010100100101111100001000010000011000000100001000010000100001;
     27:datos[0:144]<=145'b0000100001000010000100001000010000101100011110111101111010010101101110011010101001101010010110001100011111000001111011000000100001000010000100001;
     28:datos[0:144]<=145'b0000100001000010000100001000010110001111100001000001111011000100101110011010100101101011000111110000100000111101100000010000100001000010000100001;
     29:datos[0:144]<=145'b0000100001000010000100001011000111110000011110111110000011110110001110011010110001101011000111110000011110110000001000010000100001000010000100001;
     30:datos[0:144]<=145'b0000100001000010000100001011000110010000100000111101100011001000101110011011000101100011110110001111011000000100001000010000100001000010000100001;
     31:datos[0:144]<=145'b0000100001000010000101100011111000010000100000110010001100011000101110011101000101110011010110101110000010000100001000010000100001000010000100001;
     32:datos[0:144]<=145'b0000100001000010110001111100000110010000011110110010001100011000110001100011000100010000100001000010000100000100001000010000100001000010000100001;
     33:datos[0:144]<=145'b0000100001000010110001110011100111001100011000001000010000100001000010000100001000010000100001000010000100001000011000010000100001000010000100001;
     34:datos[0:144]<=145'b0000100001000100111001101011010111001110000100001000010000100001000010000100001100011011100111001110011100111000011000010000100001000010000100001;
     35:datos[0:144]<=145'b0001000010000100001000010000100001000010000100001000010000100001000010000100001000010000100001000010000100001000010000100000100001000010000100001;
     36:datos[0:144]<=145'b0001000011000100001000010000100001000011000100001000010000100001000010000100001000010000100001000010000100001000010000100000100001000010000100001;
     37:datos[0:144]<=145'b0000100011000110111001110011100001100010000100001000010000100001000010000100001000010000100001000010000100001000001000010000100001000010000100001;
     38:datos[0:144]<=145'b0000100001000010000100001000010001000010000100001000010000100001000010000100001000010000100000100001000010000100001000010000100001000010000100001;
     default: datos[0:144]<=145'd0;

   endcase
end

//Map Color
assign color[11:0]=          (image_line[4:0]==1)?12'd240:
          (image_line[4:0]==2)?12'd0:
          (image_line[4:0]==3)?12'd819:
          (image_line[4:0]==4)?12'd3479:
          (image_line[4:0]==5)?12'd2677:
          (image_line[4:0]==6)?12'd3497:
          (image_line[4:0]==7)?12'd3787:
          (image_line[4:0]==8)?12'd4095:
          (image_line[4:0]==9)?12'd54:
          (image_line[4:0]==10)?12'd73:
          (image_line[4:0]==11)?12'd108:
          (image_line[4:0]==12)?12'd3138:
          (image_line[4:0]==13)?12'd3003:
          (image_line[4:0]==14)?12'd1911:
          (image_line[4:0]==15)?12'd3697:
          (image_line[4:0]==16)?12'd3984:
          (image_line[4:0]==17)?12'd1919:
             12'd0;


endmodule
