module render_g3(input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);


wire [10:0]real_x=(x_video[10:0]>>scale[3:0])-(x_pos[10:0]>>scale[3:0]);
wire [10:0]real_y=(y_video[10:0]>>scale[3:0])-(y_pos[10:0]>>scale[3:0]);

wire [3:0]image_line;
wire [10:0]bit_posx=real_x[5:0]*4;
reg [0:115]datos;
assign image_line[0]=datos[bit_posx[10:0]+3];
assign image_line[1]=datos[bit_posx[10:0]+2];
assign image_line[2]=datos[bit_posx[10:0]+1];
assign image_line[3]=datos[bit_posx[10:0]+0];
assign image_on= (color[11:0]!=12'h0f0) & on_off & (real_x[10:0]>=11'd0) & (real_x[10:0]<11'd29)& (real_y[10:0]>=11'd0) & (real_y[10:0]<11'd41);

always@(posedge clk)
begin
  case(real_y[10:0])

     0:datos[0:115]<=116'b00010001000100010001000100010001000100010001000100010001000100100001000100010001001000100010001000100010001000100001;
     1:datos[0:115]<=116'b00010001000100010001000100010001000100010001000100010001001000100001000100100010001000100010001000100010001000010001;
     2:datos[0:115]<=116'b00010001000100010001000100010001000100010001000100010010001100100001001000100010001100110011001100100001000100010001;
     3:datos[0:115]<=116'b00010001000100010001000100010001001000100001000100100010001100100010001000100011001100110010001000010001000100010001;
     4:datos[0:115]<=116'b00010001000100010001000100010001000100010010000100100010001000100010001000110011001100100010000100010001000100010001;
     5:datos[0:115]<=116'b00010001000100010001000100010001000100010001001000100010001000100010001000110011001000100010001000100001000100010001;
     6:datos[0:115]<=116'b00010001000100010001000100010001000100010001001000100010001000110010001000100010001000110011001100100010000100010001;
     7:datos[0:115]<=116'b00010001000100010001000100010001000100010010001000100010001100110011001000100010001100110011001100110010001000010001;
     8:datos[0:115]<=116'b00010001000100010001000100010001000100100010001000100010001100110011001000110010001000110010001000100010001000100001;
     9:datos[0:115]<=116'b00010001000100010001000100010001000100100010001000100010001000110010010000100100001000100010000100010001000100100001;
     10:datos[0:115]<=116'b00010001000100010001000100010010001000100010001000100010001000100100001000100010010000100001000100010001000100010001;
     11:datos[0:115]<=116'b00010001000100010001001000100010001000100010001000100101010100100110011110000010001000010001000100010100010001000001;
     12:datos[0:115]<=116'b00010001000100010010001000100010001000100010001001010100011101000110100010000010011000010001000101010110011101000001;
     13:datos[0:115]<=116'b00010001000100010001000100010010001000100010001001010100010101000100011101110111011101000001000101010100010001010001;
     14:datos[0:115]<=116'b00010001000100010001001000100010001000100010001000100101011101010100011001110110011001010001010101110110010001110100;
     15:datos[0:115]<=116'b00010001000100100010001000100010001000100010001000100010010101010101011001100110010100010001010101100100011001100101;
     16:datos[0:115]<=116'b00010001000100010001010101000101010110011001010101011001010001100100010001010101100110010101101001010110010110100001;
     17:datos[0:115]<=116'b00010001000100010101010001110111010101010101011001110101100101010110010110011011110010010100101010101010101010100001;
     18:datos[0:115]<=116'b00010001000100010101011001100110101010100101011001010101010101010100010110011100100101000110010101101010101000010001;
     19:datos[0:115]<=116'b00010001000100010001010101101010101010100110011001110100010110010101100110111001010001100111011001100100010100010001;
     20:datos[0:115]<=116'b00010001000100010001000101011010101010100100011101000101101110011001101110011001010101010101010101010101000100010001;
     21:datos[0:115]<=116'b00010001000100010001000100010001101010101010010101011011110010111001101110010001000100010001000100010001000100010001;
     22:datos[0:115]<=116'b00010001000100010001000100010001000100011001101110111100110011001011100100010001000100010001000100010001000100010001;
     23:datos[0:115]<=116'b00010001000100010001000100010001000100010001110111101110110111101110110100010001000100010001000100010001000100010001;
     24:datos[0:115]<=116'b00010001000100010001000100010001000100011001110111011101110111011101101110011001000100010001000100010001000100010001;
     25:datos[0:115]<=116'b00010001000100010001000100010001000110011011100110111001110111101101110010111001100110100001000100010001000100010001;
     26:datos[0:115]<=116'b000100010001000100010001000100011001101111001011101110111101111011011011100111111000010101010000100010001000100010001;
     27:datos[0:115]<=116'b0001000100010001000100010001100110011001100111001011110111101011111010011111111110000100001111101000010001000100010001;
     28:datos[0:115]<=116'b0001000100010001000100010001101011111111111110011001110111101001111010101010111110000100001111101000010001000100010001;
     29:datos[0:115]<=116'b0001000100010001000100011010111110000100001111111110101101111010101110101011111010111111111010000100010001000100010001;
     30:datos[0:115]<=116'b00010001000100010001101011111000011111111100001111101011011110000110101010111110000111110100001000100010001000100010001;
     31:datos[0:115]<=116'b0001000100010001000110101010100001000011111010101000011101110100011010111110101111101000010001000100010001000100010001;
     32:datos[0:115]<=116'b00010001000100011010111111111000010000100001010000100010001000100011101111011101101000100010001000100010001000100010001;
     33:datos[0:115]<=116'b0001000100011010101011111000011111000010100001000100010001000111010010001000100010000100010001000100010001000100010001;
     34:datos[0:115]<=116'b00010001000110101101110111011101111110100001000100010001000100110010001000100010001000010001000100010001000100010001;
     35:datos[0:115]<=116'b00010001000111011101111011101101101000100010001000100010001000101101001000100010001000100011000100010001000100010001;
     36:datos[0:115]<=116'b00010001001000100010001000100010001000100010001000100010001000100010001111011101110111010011000100010001000100010001;
     37:datos[0:115]<=116'b00100010001000100010001000100011001000100010001000100010001000100010001000100010001000100010001000010001000100010001;
     38:datos[0:115]<=116'b00100011001000100010001000110011001000100010001000100010001000100010001000100010001000100010001000010001000100010001;
     39:datos[0:115]<=116'b00010011001111011101001100110010001000100010001000100010001000100010001000100010001000100001000100010001000100010001;
     40:datos[0:115]<=116'b00010001000100010001000100100010001000100010001000100010001000100010001000010001000100010001000100010001000100010001;
     default: datos[0:115]<=116'd0;

   endcase
end

//Map Color
assign color[11:0]=          (image_line[3:0]==1)?12'd240:
          (image_line[3:0]==2)?12'd0:
          (image_line[3:0]==3)?12'd819:
          (image_line[3:0]==4)?12'd3479:
          (image_line[3:0]==5)?12'd2677:
          (image_line[3:0]==6)?12'd3497:
          (image_line[3:0]==7)?12'd3787:
          (image_line[3:0]==8)?12'd4095:
          (image_line[3:0]==9)?12'd54:
          (image_line[3:0]==10)?12'd3138:
          (image_line[3:0]==11)?12'd73:
          (image_line[3:0]==12)?12'd108:
          (image_line[3:0]==13)?12'd1911:
          (image_line[3:0]==14)?12'd3003:
          (image_line[3:0]==15)?12'd3697:
          (image_line[3:0]==16)?12'd3984:
             12'd0;


endmodule
