module render_g4(input clk,input [3:0]scale,input on_off,input [10:0]x_video,input [10:0]y_video,input [10:0]x_pos,input [10:0]y_pos,output image_on,output [11:0]color);


wire [10:0]real_x=(x_video[10:0]>>scale[3:0])-(x_pos[10:0]>>scale[3:0]);
wire [10:0]real_y=(y_video[10:0]>>scale[3:0])-(y_pos[10:0]>>scale[3:0]);

wire [3:0]image_line;
wire [10:0]bit_posx=real_x[5:0]*4;
reg [0:115]datos;
assign image_line[0]=datos[bit_posx[10:0]+3];
assign image_line[1]=datos[bit_posx[10:0]+2];
assign image_line[2]=datos[bit_posx[10:0]+1];
assign image_line[3]=datos[bit_posx[10:0]+0];
assign image_on= (color[11:0]!=12'h0f0) & on_off & (real_x[10:0]>=11'd0) & (real_x[10:0]<11'd29)& (real_y[10:0]>=11'd0) & (real_y[10:0]<11'd41);

always@(posedge clk)
begin
  case(real_y[10:0])

     0:datos[0:115]<=116'b00010001000100010001000100010001000100010001000100010001000100010010000100010001000100010001000100010001000100010001;
     1:datos[0:115]<=116'b00010001000100010001000100010001000100010001000100010001000100100010000100010001001000100010001000100010001000100001;
     2:datos[0:115]<=116'b00010001000100010001000100010001000100010001000100010001001000100001000100100010001000100010001100100010001000010001;
     3:datos[0:115]<=116'b00010001000100010001000100010001000100100001000100010010001100100001001000100010001100110011001100100001000100010001;
     4:datos[0:115]<=116'b00010001000100010001000100010001000100010010000100100010001100100010001000100011001100110010001000010001000100010001;
     5:datos[0:115]<=116'b00010001000100010001000100010001000100010010000100100010001000100010001000110011001100100010000100010001000100010001;
     6:datos[0:115]<=116'b00010001000100010001000100010001000100010001001000100010001000100010001000110011001000100010001000100010000100010001;
     7:datos[0:115]<=116'b00010001000100010001000100010001000100010001001000100010001000110010001000100010001000110011001100110010001000100001;
     8:datos[0:115]<=116'b00010001000100010001000100010001000100010010001000100010001100110011001000100010001100110011001100100010001000010001;
     9:datos[0:115]<=116'b00010001000100010001000100010001000100100010001000100010001100110011001000110010001000110010001000010001000100010001;
     10:datos[0:115]<=116'b00010001000100010001000100010001000100100010001000100010001000110010010001000010001000100010000100010001000100010001;
     11:datos[0:115]<=116'b00010001000100010001000100010010001000100010001000100010001000100100001000100010010000010010000100010001000100010001;
     12:datos[0:115]<=116'b00010001000100010010001000100010001000100010001000100101010100100110011110000010001000010001000100010001000100010001;
     13:datos[0:115]<=116'b00010001000100010001001000100010001000100010001001010100011101000110100010000010011000010001000100010100010001000001;
     14:datos[0:115]<=116'b00010001000100010001000100010010001000100010001001010100010101000100011101110111011101000001000101010110011101000001;
     15:datos[0:115]<=116'b00010001000100100010001000100010001000100010001000100101011101010100011001110110011001010001000101010100010001010001;
     16:datos[0:115]<=116'b00010001000100010001001000100010001000100010001000100010010101010101011001100110010100010001010101110110010001110100;
     17:datos[0:115]<=116'b00010001000100010001000100010101010110011010101010101001010001100100010001010101100110010101010101100100011001100101;
     18:datos[0:115]<=116'b00010001000100010001010101010110011001001001010101011010100101100110010110011010101110010100110001010110010111000001;
     19:datos[0:115]<=116'b00010001000100010101010001100111011001000101011001110101101010010100100110011011100101000110110011001100110011000001;
     20:datos[0:115]<=116'b00010001000100010101011001110100110011000101011001010101010110010101100110101001010001100111011001011100110000010001;
     21:datos[0:115]<=116'b00010001000100010101010001101100110011000110011001110100010110101001101010010101010101010101010101010101000100010001;
     22:datos[0:115]<=116'b00010001000100010001010101011100110011000100011101000101101110101001101010010001000100010001000100010001000100010001;
     23:datos[0:115]<=116'b00010001000100010001000100010101110011000101010101011010101010111010100100010001000100010001000100010001000100010001;
     24:datos[0:115]<=116'b00010001000100010001000100010001000100010001110111011110110111101110110110010001000100010001000100010001000100010001;
     25:datos[0:115]<=116'b00010001000100010001000100010001000100011001110111011101110111011101101010011001100100010001000100010001000100010001;
     26:datos[0:115]<=116'b00010001000100010001000100010001000110011010100110101001110111101101101010101001111111001100000100010001000100010001;
     27:datos[0:115]<=116'b000100010001000100010001000100011001101010111010101010101101111011101101100111111111100001111110000010001000100010001;
     28:datos[0:115]<=116'b00010001000100010001000100011001100110011001100110111010110111101110110111111111100001000010000110000010001000100010001;
     29:datos[0:115]<=116'b000100010001000100010001000111001111111111111100100110011101111011011110110011001111100001111110000010001000100010001;
     30:datos[0:115]<=116'b000100010001000100010001110011111000010000111111111100110111101100110111101111100001000011111100000100010001000100010001;
     31:datos[0:115]<=116'b0001000100010001000111001100100001111111110000111111001101111000011100110011111111111111000001000100010001000100010001;
     32:datos[0:115]<=116'b00010001000100010001110010000100001000011111100110000011101110100011101010011011100110000010001000100010001000100010001;
     33:datos[0:115]<=116'b00010001000100011100111110000100001000011000001000100010001000100011101110111101101110100010001000100010001000100010001;
     34:datos[0:115]<=116'b0001000100011100111110000111110000111111000001000100010001000100110010001000100010001000010001000100010001000100010001;
     35:datos[0:115]<=116'b00010001000111001101110111011101110000100010001000100010001000111101110100100010001000100011000100010001000100010001;
     36:datos[0:115]<=116'b00010001001011011101111011011101001000100010001000100010001000100010001011011101110111010011000100010001000100010001;
     37:datos[0:115]<=116'b00100010001000100010001000100011001000100010001000100010001000100010001000100010001000100010001000010001000100010001;
     38:datos[0:115]<=116'b00100011001000100010001000110011001000100010001000100010001000100010001000100010001000100010001000010001000100010001;
     39:datos[0:115]<=116'b00010011001111011101110100110010001000100010001000100010001000100010001000100010001000100001000100010001000100010001;
     40:datos[0:115]<=116'b00010001000100010001000100100010001000100010001000100010001000100010001000010001000100010001000100010001000100010001;
     default: datos[0:115]<=116'd0;

   endcase
end

//Map Color
assign color[11:0]=          (image_line[3:0]==1)?12'd240:
          (image_line[3:0]==2)?12'd0:
          (image_line[3:0]==3)?12'd819:
          (image_line[3:0]==4)?12'd3479:
          (image_line[3:0]==5)?12'd2677:
          (image_line[3:0]==6)?12'd3497:
          (image_line[3:0]==7)?12'd3787:
          (image_line[3:0]==8)?12'd4095:
          (image_line[3:0]==9)?12'd54:
          (image_line[3:0]==10)?12'd73:
          (image_line[3:0]==11)?12'd108:
          (image_line[3:0]==12)?12'd3138:
          (image_line[3:0]==13)?12'd1911:
          (image_line[3:0]==14)?12'd3003:
          (image_line[3:0]==15)?12'd3697:
          (image_line[3:0]==16)?12'd3984:
             12'd0;


endmodule
